package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.verifications;

import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatDouble;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Vrification de la signature d'un message
 *
 */
public class VerifierSignatureMessage{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(VerifierSignatureMessage.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param typeAlgo Type de l'algorithme
	 * @param idCle Identifiant de la cl publique
	 * @param message Message
	 * @param signature Signature  vrifier
	 * @return Rsultat de l'opration 
	 * @throws ExceptionTraitement
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, long typeAlgo, long idCle, char[] message, String signature) throws ExceptionTraitement {

		try {
			
			if(librairie != null) {
				
				if(message != null) {
		
					CK_MECHANISM algo = new CK_MECHANISM();
					algo.mechanism=typeAlgo;
					
					ResultatDouble resultat = new ResultatDouble("Vrification de la signature d'un message avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Initialisation (C_VerifyInit))","Vrification de la signature d'un message avec "+TraitementsUtil.getNomAlgo(typeAlgo)+" (Vrification (C_Verify))");
					
					if(message != null) {
						
						byte[] signatureOctets = TraitementsUtil.getOctetsSansFormatage(signature);
						boolean erreurSurvenue = false;
						
						// Traitements  tester
						try {
							
							//# INIT #//
							librairie.C_VerifyInit(idSession, algo, idCle);
							
						} catch (PKCS11Exception e) {
							
							log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
							resultat.setCodeRetour(e.getErrorCode());
							erreurSurvenue = true;
							resultat.setCodeRetour2(TraitementsUtil.AUCUN_CODE_RETOUR);
							resultat.appendOperation2(" NON EXECUTEE!");
							
						}
						try {
							
							//# VERIFICATION DE LA SIGNATURE #//
							if(!erreurSurvenue) {
								librairie.C_Verify(idSession,new String(message).getBytes(),signatureOctets);
							}
							
						} catch (PKCS11Exception e) {
							
							log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
							resultat.setCodeRetour2(e.getErrorCode());
							
						}
					}
			
					return resultat;
					
				} else {
				
					// Si le message est null il est impossible de raliser l'opration
					log.error("Le message est nul");
					throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_VERIFICATION_MESSAGE, "Le message est nul");				
				
				}
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_VERIFICATION_MESSAGE, "La librairie est nulle");
				
			}
				
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_VERIFICATION_MESSAGE, "Une erreur inattendue est survenue");
			
		}
		
	}
	
}
